/* SCE CONFIDENTIAL
* PlayStation(R)3 Programmer Tool Runtime Library 430.001
* Copyright (C) 2012 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _SCE_SNS_INTERFACE_H
#define _SCE_SNS_INTERFACE_H

#include "np_toolkit_defines.h"

namespace sce {
	namespace Toolkit{
		namespace NP{

			/// @brief
			/// The namespace containing PSN social networking services functionality.
			///	
			/// The namespace containing PSN social networking services functionality.
			namespace Sns {
			/// @brief
			/// The SNS interface allows users to post a message to a Facebook.
			///
			/// The SNS interface allows users to post a message to a Facebook.
			class Interface
			{
			public:

		/// @brief 
		/// Posts a message to the user's Facebook "Wall".
		///
		/// Posts a message to the user's Facebook "Wall".
		/// 
		/// @param msgDetails	A reference to a structure containing information about the message to post.
		///
		/// @retval				SCE_TOOLKIT_NP_SUCCESS				The operation was successful.
		/// @retval				SCE_TOOLKIT_NP_NOT_INITIALISED		The operation failed because the %NP %Toolkit library was not initialized.
		static int postMessageFb(const SnsPostFacebook &msgDetails);

				/// @brief 
				/// Sets the Facebook Application ID.
				///
				/// Sets the Facebook Application ID, which is stored in the SNS Service.
				/// This ID is supplied by Facebook when an application is created.
				/// 
				/// @param id			The value to set the ID to.
				///
				/// @retval				SCE_TOOLKIT_NP_SUCCESS				The operation was successful. 
				/// @retval				SCE_TOOLKIT_NP_NOT_INITIALISED		The operation failed because the %NP %Toolkit library was not initialized.
				static int setAppIdFb(const uint64_t &id);

			};

			}//end Sns
		}//end NP
	}//end Toolkit
}//end sce
#endif
